#define LCD_BACKLIGHT  47
#define LCD_CS         46
#define LCD_DC         44
#define LCD_RST        45

#include "ST7567_FB.h" //knihovna displeje
#include <SPI.h>
ST7567_FB lcd(LCD_DC, LCD_RST, LCD_CS);

#include "c64enh_font.h" //knihovna fontu

//spinani a regulace cerpadel
bool cerpadlo1 = false;
bool cerpadlo2 = false;
bool cerpadlo3 = false;
bool cerpadlo4 = false;

byte rele1 = 26; //rele1 pin 26
byte rele2 = 27; //rele2 pin 27
byte rele3 = 28; //rele3 pin 28
byte rele4 = 29; //rele4 pin 29

int pwm1 = 2; //pwm pin 2
int pwm2 = 3; //pwm pin 3
int pwm3 = 4; //pwm pin 4
int pwm4 = 5; //pwm pin 5

float rychlost1 = 0; //promenne 0 - 255 pro pwm regulaci
float rychlost2 = 0;
float rychlost3 = 0;
float rychlost4 = 0;
float rychlostPWM = 0;
float aktualniRychlost = 0;

int enkoder = 0;

//enkoder
int skok = 1;    // skok o 5%
unsigned long aktualniCas;
unsigned long smycka;
const int pin_A = 6;  // pin 6
const int pin_B = 7;  // pin 7
unsigned char enkoder_A;
unsigned char enkoder_B;
unsigned char enkoder_A_prev=0;

//vstupy cidel


//tlacitka
int nahoru = 10;
int dolu = 11;
int vyber = 12;
int zpet = 9;
int zpet2 = 8;
int navrat = 0;

int i = 0;

//menu
int menu = 1;
int menu2 = 1;
int prehled = 1;
int cerpadla = 0;
int akumulator = 0;
int dalsi = 0;
int nastCerpadel = 0;

bool nastRychlost = false;
bool nastPrutoku = false;
bool nastCasovace = false;
bool nastCyklu = false;

char cerpadlo[10];
//mereni napeti akumulatoru
int uvstup = A0;
float vout = 0.0;
float vin = 0.0;
float R1 = 30000.0;
float R2 = 4500.0; 
int value = 0;

char napeti [64];
char rychlostPCT [8]; 

int led1 = 22;
int led2 = 23;
int led3 = 24;
int led4 = 25;
//int led5 = 3;

//Prutokomer
int pinPrutokomer = 21;
byte pinPreruseni = 2;  

const float kalibrace = 7.2;
volatile byte pulzy = 0;
float prutok = 0.0;
unsigned int prutokML = 0;
unsigned long soucetML = 0;
unsigned long staryCas = 0;

char prutokPrint [8];
char prutokMLPrint [8];
char soucetMLPrint [8];


void setup() {
//displej
  Serial.begin(9600);
  pinMode(LCD_BACKLIGHT, OUTPUT);
  digitalWrite(LCD_BACKLIGHT, LOW);
  lcd.init();
  lcd.setFont(c64enh);

//menu
  pinMode(nahoru, INPUT_PULLUP);
  pinMode(dolu, INPUT_PULLUP);
  pinMode(vyber, INPUT_PULLUP);
  pinMode(zpet, INPUT_PULLUP);
  pinMode(zpet2, INPUT_PULLUP);
  
  hlavniMenu();

//mereni napeti
  Serial.println(napeti);
  pinMode(uvstup, INPUT);

//diody pokus
  pinMode(led1,OUTPUT);
  pinMode(led2,OUTPUT);
  pinMode(led3,OUTPUT);
  pinMode(led4,OUTPUT);
 // pinMode(led5,OUTPUT);

//spinani a regulace
  pinMode(rele1, OUTPUT);
  pinMode(rele2, OUTPUT);
  pinMode(rele3, OUTPUT);
  pinMode(rele4, OUTPUT);

  pinMode(pwm1, OUTPUT);
  pinMode(pwm2, OUTPUT);
  pinMode(pwm3, OUTPUT);
  pinMode(pwm4, OUTPUT);

//enkoder
  pinMode(pin_A, INPUT);
  pinMode(pin_B, INPUT);
  aktualniCas = millis();
  smycka = aktualniCas;

//prutokomer
  pinMode(pinPrutokomer, INPUT);
  attachInterrupt(pinPreruseni, prictiPulz, FALLING);
}

void loop() {
voltmetr();

//spousteniCerpadla1
  if (cerpadlo1 && (vin>10.7)){
    digitalWrite(rele1, 0);
  }
  else{
    digitalWrite(rele1, HIGH);
  }

  if (cerpadlo2 && (vin>10.7)){
    digitalWrite(rele2, 0);
  }
  else{
    digitalWrite(rele2, HIGH);
  }
  
  if (cerpadlo3 && (vin>10.7)){
    digitalWrite(rele3, 0);
  }
  else{
    digitalWrite(rele3, HIGH);
  }

  if (cerpadlo4 && (vin>10.7)){
    digitalWrite(rele4, 0);
  }
  else{
    digitalWrite(rele4, HIGH);
  }

//pwm regulace
    analogWrite(pwm1, rychlost1);  
   // analogWrite(pwm2, rychlost2);  
   // analogWrite(pwm3, rychlost3);  
   // analogWrite(pwm4, rychlost4);  
    
//enkoder
  aktualniCas = millis();
  if(aktualniCas >= (smycka + 0)){

    enkoder_A = digitalRead(pin_A); 
    enkoder_B = digitalRead(pin_B);   
    if((!enkoder_A) && (enkoder_A_prev)){

      if(enkoder_B) {
        if(enkoder + skok <= 100) enkoder += skok;               
      }   
      else {
        if(enkoder - skok >= 0) enkoder -= skok;               
      }   
    }   
    enkoder_A_prev = enkoder_A;     
    
    smycka = aktualniCas;  
  }

if (!nastRychlost && !nastPrutoku && !nastCasovace && !nastCyklu){
 if (!digitalRead(dolu)){
      switch (menu2) {
      case 1:
        menu++;
        hlavniMenu();
       break;
      case 2:
        prehled++;
        action1();
        break;
      case 3:
        cerpadla++;
        action2();
        break;
      case 4:
        action3();
        break;
      case 5:
        action4();
        break;
      case 6:
        dalsi++;
        action5();
        break;
      case 7:
        nastCerpadel++;
        nastaveniCerpadel();
        break;
       }
       delay(100);
    while (!digitalRead(dolu));
  }
  if (!digitalRead(nahoru)){
     switch (menu2) {
      case 1:
        menu--;
        hlavniMenu();
        break;
      case 2:
        prehled--;
        action1();
        break;
      case 3:
        cerpadla--;
        action2();
        break;
      case 4:
        action3();
        break;
      case 5:
        action4();
        break;
      case 6:
        dalsi--;
        action5();
        break;
      case 7:
        nastCerpadel--;
        nastaveniCerpadel();
        break;
      }
    delay(100);
    while(!digitalRead(nahoru));
  }
  if (!digitalRead(vyber)){
    switch (menu) {
      case 0:
        menu = 1;
        break;      
      case 1:
        menu2 = 2;
        switch (prehled) {
            case 0:
              prehled = 1;
              break;  
            case 1:
              action1();
              break;
            case 2:
              menu = 1;
              menu2 = 1;
              prehled = 1;
              delay(100);
              hlavniMenu();
              break;
            case 3:
              prehled = 2;
              break;
        }
       break;
      case 2:
        menu2 = 3;
        switch (cerpadla) {
            case 0:
              cerpadla = 1;
              action2();
              break;            
            case 1:
              //action2();                        
              nastaveniCerpadel();
              break;
            case 2:
              //action2();            
              nastaveniCerpadel();
              break;
            case 3:
              //action2(); 
              nastaveniCerpadel();
              break;
            case 4:
              //action2(); 
              nastaveniCerpadel();
              break;
            case 5:
              menu = 1;
              menu2 = 1;
              cerpadla = 0;
              delay(100);
              hlavniMenu();
              break;
            case 6:
              cerpadla = 5;
              break;
        }
        break;
      case 3:
        menu2 = 4;
        action3();
        break;
      case 4:
        menu2 = 5;
        action4();
        break;
      case 5:
        menu2 = 6;
//        action5();
          switch (dalsi) {
            case 0:
              dalsi = 1;
              action5();
            break;            
            case 1:
              //action5();            
//             if (!digitalRead(vyber)){
                digitalWrite(led1,HIGH);
                digitalWrite(led2,LOW);
//              while (!digitalRead(vyber));}
              break;
            case 2:
              //action5();
              digitalWrite(led1,LOW);
              digitalWrite(led2,HIGH);
              break;
            case 3:
              //action5();
              break;
            case 4:
              //action5();
              break;
            case 5:
              menu = 1;
              menu2 = 1;
              dalsi = 0;
              delay(100);
              hlavniMenu();
              break;
            case 6:
              dalsi = 6;
              break;
            }
        break;
      case 6:
        menu = 5;
      break;
  }
    delay(100);
    while (!digitalRead(vyber));
  }

 if (!digitalRead(zpet))
 {
      menu = 1;
      menu2 = 1;
      prehled = 1;
      cerpadla = 0;
      dalsi = 0;
      akumulator = 0;
      nastCerpadel = 0;
      delay(100);        
      hlavniMenu();
      digitalWrite(led1,LOW);
      digitalWrite(led2,LOW);
      digitalWrite(led3,LOW);
      digitalWrite(led4,LOW);
     
    while (!digitalRead(zpet));
  }

 if (!digitalRead(zpet2))
 {
    
    switch (menu2) {
            case 0:

            break;            
            case 1:

            break;
            case 2:
              menu2 = 1;
              hlavniMenu();
            break;
            case 3:
              menu2 = 1;
              cerpadla = 0;
              hlavniMenu();
            break;
            case 4:

            break;
            case 5:
              menu2 = 1;
              hlavniMenu();
            break;
            case 6:
              menu2 = 1;
              dalsi=0;
              hlavniMenu();
            break;
            case 7:
              menu2 = 3;
              nastCerpadel=0;
              action2();
            break;
            }

      navrat++;
//     cerpadlo1 = true;
//      if (menu2=4) {
//        hlavniMenu();
//      }     
    while (!digitalRead(zpet2));      

  }
}
else{
  if (nastRychlost==true){
    rychlost();
  }

  if (nastPrutoku==true){
    prutokomer();
    
  }

  if (nastCasovace==true){
    casovac();
  }

  if (nastCyklu==true){
    cykly();
  }
}

}

void hlavniMenu(){
switch (menu) {
    case 0:
      menu = 1;
      break;
    case 1:
      lcd.clearDisplay();
      lcd.printStr(2, 2, ">Prehled");
      lcd.printStr(9, 15, "Nastaveni cerpadel");
      lcd.printStr(9, 28, "Stav akumulatoru");
      lcd.printStr(9, 41, "Dalsi");
      lcd.printStr(9, 54, "Dalsi");
      lcd.display();
      break;
    case 2:
      lcd.clearDisplay();
      lcd.printStr(9, 2, "Prehled");
      lcd.printStr(2, 15, ">Nastaveni cerpadel");
      lcd.printStr(9, 28, "Stav akumulatoru");
      lcd.printStr(9, 41, "Dalsi");
      lcd.printStr(9, 54, "Dalsi");
      lcd.display();
      break;
    case 3:
      lcd.clearDisplay();
      lcd.printStr(9, 2, "Prehled");
      lcd.printStr(9, 15, "Nastaveni cerpadel");
      lcd.printStr(2, 28, ">Stav akumulatoru");
      lcd.printStr(9, 41, "Dalsi");
      lcd.printStr(9, 54, "Dalsi");
      lcd.display();
      break;
    case 4:
      lcd.clearDisplay();
      lcd.printStr(9, 2, "Prehled");
      lcd.printStr(9, 15, "Nastaveni cerpadel");
      lcd.printStr(9, 28, "Stav akumulatoru");
      lcd.printStr(2, 41, ">Dalsi");
      lcd.printStr(9, 54, "Dalsi");
      lcd.display();
      break;
    case 5:
      lcd.clearDisplay();
      lcd.printStr(9, 2, "Prehled");
      lcd.printStr(9, 15, "Nastaveni cerpadel");
      lcd.printStr(9, 28, "Stav akumulatoru");
      lcd.printStr(9, 41, "Dalsi");
      lcd.printStr(2, 54, ">Dalsi");
      lcd.display();
      break;
    case 6:
      menu = 5;
      break;
  }
}
/*
void vyber2() {
  menu2 = 2;
  switch (menu) {
    case 1:
      action1();
      break;
    case 2:
      action2();
      break;
    case 3:
      action3();
      break;
    case 4:
      action4();
      break;
    case 5:
      action5();
      break;
  }
}
*/
void action1() {
   switch (prehled) {
    case 0:
      prehled = 1;
      break;
    case 1:
      lcd.clearDisplay();
      lcd.printStr(2, 2, ">Prehled");
      lcd.printStr(9, 15, "Zpet");

      lcd.display();
      break;
   case 2:
      lcd.clearDisplay();
      lcd.printStr(9, 2, "Prehled");
      lcd.printStr(2, 15, ">Zpet");

      lcd.display();
      break;
    case 3:
      prehled =2;
      break;
  }
}
void action2() {
   switch (cerpadla) {
    case 0:
      lcd.clearDisplay();
      lcd.printStr(2, 2, ">Cerpadlo 1");
      lcd.printStr(9, 15, "Cerpadlo 2");
      lcd.printStr(9, 28, "Cerpadlo 3");
      lcd.printStr(9, 41, "Cerpadlo 4");
      lcd.printStr(9, 54, "Zpet");
      lcd.display();
      cerpadla = 1;
      break;
    case 1:
      lcd.clearDisplay();
      lcd.printStr(2, 2, ">Cerpadlo 1");
      lcd.printStr(9, 15, "Cerpadlo 2");
      lcd.printStr(9, 28, "Cerpadlo 3");
      lcd.printStr(9, 41, "Cerpadlo 4");
      lcd.printStr(9, 54, "Zpet");
      lcd.display();
      break;
    case 2:
      lcd.clearDisplay();
      lcd.printStr(9, 2, "Cerpadlo 1");
      lcd.printStr(2, 15, ">Cerpadlo 2");
      lcd.printStr(9, 28, "Cerpadlo 3");
      lcd.printStr(9, 41, "Cerpadlo 4");
      lcd.printStr(9, 54, "Zpet");
      lcd.display();
      break;
    case 3:
      lcd.clearDisplay();
      lcd.printStr(9, 2, "Cerpadlo 1");
      lcd.printStr(9, 15, "Cerpadlo 2");
      lcd.printStr(2, 28, ">Cerpadlo 3");
      lcd.printStr(9, 41, "Cerpadlo 4");
      lcd.printStr(9, 54, "Zpet");
      lcd.display();
      break;
    case 4:
      lcd.clearDisplay();
      lcd.printStr(9, 2, "Cerpadlo 1");
      lcd.printStr(9, 15, "Cerpadlo 2");
      lcd.printStr(9, 28, "Cerpadlo 3");
      lcd.printStr(2, 41, ">Cerpadlo 4");
      lcd.printStr(9, 54, "Zpet");
      lcd.display();
      break;
    case 5:
      lcd.clearDisplay();
      lcd.printStr(9, 2, "Cerpadlo 1");
      lcd.printStr(9, 15, "Cerpadlo 2");
      lcd.printStr(9, 28, "Cerpadlo 3");
      lcd.printStr(9, 41, "Cerpadlo 4");
      lcd.printStr(2, 54, ">Zpet");
      lcd.display();
      break;
    case 6:
      cerpadla = 5;
      break;
  }
}

void printVypzap(){
 switch (cerpadla){
            case 1:
              if(cerpadlo1 == false){
                lcd.printStr(9, 54, "Zapnout cerpadlo");
              }else{
                lcd.printStr(9, 54, "Vypnout cerpadlo");
              }
            break;
            case 2:
              if(cerpadlo2 == false){
                lcd.printStr(9, 54, "Zapnout cerpadlo");
              }else{
                lcd.printStr(9, 54, "Vypnout cerpadlo");
              }
            break; 
            case 3:
              if(cerpadlo3 == false){
                lcd.printStr(9, 54, "Zapnout cerpadlo");
              }else{
                lcd.printStr(9, 54, "Vypnout cerpadlo");
              }
            break;
            case 4:
              if(cerpadlo4 == false){
                lcd.printStr(9, 54, "Zapnout cerpadlo");
              }else{
                lcd.printStr(9, 54, "Vypnout cerpadlo");
              }
            break;        
         }
}

void nastaveniCerpadel() {

  menu2 = 7;
  snprintf(cerpadlo,3,"%02d",cerpadla);
   switch (nastCerpadel) {
    case 0:
      nastCerpadel = 1;
      lcd.clearDisplay();
      lcd.printStr(2, 2, ">Rychlost");
      lcd.printStr(9, 15, "Prutok");
      lcd.printStr(9, 28, "Casovac");
      lcd.printStr(9, 41, "Pocet cyklu");
      printVypzap();
//      lcd.printStr(9, 54, "Nastavit");
      lcd.printStr(110, 2, cerpadlo);
      lcd.display();
      break;
    case 1:
      lcd.clearDisplay();
      lcd.printStr(2, 2, ">Rychlost");
      lcd.printStr(9, 15, "Prutok");
      lcd.printStr(9, 28, "Casovac");
      lcd.printStr(9, 41, "Pocet cyklu");
      printVypzap();
      lcd.printStr(110, 2, cerpadlo);
      lcd.display();

      if (!digitalRead(vyber)){         
          enkoder = 0;
          nastRychlost = true;
          delay(100);
      while(!digitalRead(vyber));
        }
      break;
    case 2:
      lcd.clearDisplay();
      lcd.printStr(9, 2, "Rychlost");
      lcd.printStr(2, 15, ">Prutok");
      lcd.printStr(9, 28, "Casovac");
      lcd.printStr(9, 41, "Pocet cyklu");
      printVypzap();

      lcd.printStr(110, 2, cerpadlo);
      lcd.display();
      if (!digitalRead(vyber)){
            enkoder = 0;
            nastPrutoku = true;
            delay(100);
      while(!digitalRead(vyber));
        }
      break;
    case 3:
      lcd.clearDisplay();
      lcd.printStr(9, 2, "Rychlost");
      lcd.printStr(9, 15, "Prutok");
      lcd.printStr(2, 28, ">Casovac");
      lcd.printStr(9, 41, "Pocet cyklu");
      printVypzap();

      lcd.printStr(110, 2, cerpadlo);
      lcd.display();
      if (!digitalRead(vyber)){
            i = 0;
            nastCasovace = true;
            delay(100);
      while(!digitalRead(vyber));
        }
      break;
    case 4:
      lcd.clearDisplay();
      lcd.printStr(9, 2, "Rychlost");
      lcd.printStr(9, 15, "Prutok");
      lcd.printStr(9, 28, "Casovac");
      lcd.printStr(2, 41, ">Pocet cyklu");
      printVypzap();

      lcd.printStr(110, 2, cerpadlo);
      lcd.display();
      if (!digitalRead(vyber)){
            enkoder = 0;
            nastCyklu = true;
            delay(100);
      while(!digitalRead(vyber));
        }
      break;
    case 5:
      lcd.clearDisplay();
      lcd.printStr(9, 2, "Rychlost");
      lcd.printStr(9, 15, "Prutok");
      lcd.printStr(9, 28, "Casovac");
      lcd.printStr(9, 41, "Pocet cyklu");
      lcd.printStr(2, 54, ">");
      printVypzap();
      lcd.printStr(110, 2, cerpadlo);
      lcd.display();
      if (!digitalRead(vyber)){         
          switch (cerpadla){
            case 1:
              if(cerpadlo1 == false){
                cerpadlo1 = true;
              }else{
                cerpadlo1 = false;
              }
            break;
            case 2:
              if(cerpadlo2 == false){
                cerpadlo2 = true;
              }else{
                cerpadlo2 = false;
              }
            break; 
            case 3:
              if(cerpadlo3 == false){
                cerpadlo3 = true;
              }else{
                cerpadlo3 = false;
              }
            break;
            case 4:
              if(cerpadlo4 == false){
                cerpadlo4 = true;
              }else{
                cerpadlo4 = false;
              }
            break;        
         }
          nastCerpadel = 0;
          cerpadla = 1;
          menu2=3;
          action2();
          delay(100);
      while(!digitalRead(vyber));
        }
      break;
    case 6:
      nastCerpadel = 5;
      break;
  }
}

void action3() {
  navrat = 0;
  while (navrat < 1) { 
    stavAkumulatoru();
  }
  menu = 3;
  menu2 = 1;
  prehled = 1;
  cerpadla = 0;
  dalsi = 0;
  akumulator = 0;
  nastCerpadel = 0;
  navrat=0;       
  hlavniMenu();
}

void action4() {
  lcd.clearDisplay();
  lcd.setFont(c64enh);
  lcd.printStr(ALIGN_CENTER, 28, ">Executing #4");
  lcd.display();
 }
void action5() {
    switch (dalsi) {
    case 0:
      dalsi = 1;
      break;
    case 1:
      lcd.clearDisplay();
      lcd.printStr(2, 2, ">Podscviceni");
      lcd.printStr(9, 15, "Jas");
      lcd.printStr(9, 28, "Hodiny");
      lcd.printStr(9, 41, "Neco 1");
      lcd.printStr(9, 54, "Zpet");
      lcd.display();
      break;
    case 2:
      lcd.clearDisplay();
      lcd.printStr(9, 2, "Podscviceni");
      lcd.printStr(2, 15, ">Jas");
      lcd.printStr(9, 28, "Hodiny");
      lcd.printStr(9, 41, "Neco 1");
      lcd.printStr(9, 54, "Zpet");
      lcd.display();
      break;
    case 3:
      lcd.clearDisplay();
      lcd.printStr(9, 2, "Podscviceni");
      lcd.printStr(9, 15, "Jas");
      lcd.printStr(2, 28, ">Hodiny");
      lcd.printStr(9, 41, "Neco 1");
      lcd.printStr(9, 54, "Zpet");
      lcd.display();
      break;
    case 4:
      lcd.clearDisplay();
      lcd.printStr(9, 2, "Podscviceni");
      lcd.printStr(9, 15, "Jas");
      lcd.printStr(9, 28, "Hodiny");
      lcd.printStr(2, 41, ">Neco 1");
      lcd.printStr(9, 54, "Zpet");
      lcd.display();
      break;
    case 5:
      lcd.clearDisplay();
      lcd.printStr(9, 2, "Podscviceni");
      lcd.printStr(9, 15, "Jas");
      lcd.printStr(9, 28, "Hodiny");
      lcd.printStr(9, 41, "Neco 1");
      lcd.printStr(2, 54, ">Zpet");
      lcd.display();
      break;
    case 6:
      dalsi = 5;
      break;
  }
}

void voltmetr()
{
  value = analogRead(uvstup);
  vout = (value * 3.3)/1024; 
  vin = vout / (R2/(R1+R2)); 
  if (vin<0.09) {
   vin=0.0;
  }
  
  dtostrf (vin, 4, 2, napeti);
    
}

void stavAkumulatoru () {
  lcd.clearDisplay();
  value = analogRead(uvstup);
  vout = (value * 3.3)/1024; 
  vin = vout / (R2/(R1+R2)); 
  if (vin<0.09) {
   vin=0.0;
  }
  //lcd.clearDisplay();
  lcd.printStr(2, 2, "Napeti:        V");  
  dtostrf (vin, 4, 2, napeti);    
  lcd.printStr(48,2, napeti);
  lcd.display();

  if (vin<10.7){
     while (i<1) {
  lcd.clearDisplay();
  lcd.printStr(ALIGN_CENTER, 28, "Nizke napeti!");
  //lcd.drawRectD(0,0,128,64,1);
  lcd.drawRect(18,20,127-18*2,63-20*2,1);
  lcd.display();
  
  
    if (!digitalRead(zpet2)){
        i++;
      while (!digitalRead(zpet2));      
   }
  }
  }
  if (vin>=10.7){
      i = 0;
   }

 if (!digitalRead(zpet2)){
  navrat++;
  while (!digitalRead(zpet2));      
  }
  delay(100);
}

void rychlost(){
//navrat = 0;
 while (i<1) {
      switch (cerpadla){
      case 1:
       enkoder = (rychlost1 / 2.55);
      break;
      case 2:
        enkoder = (rychlost2 / 2.55);
      break;
      case 3:
        enkoder = (rychlost3 / 2.55);    
      break;
      case 4:
        enkoder = (rychlost4 / 2.55);    
      break;
           }
      round(enkoder);           
      i++;
 }
  
  rychlostPWM = enkoder * 2.55;
  dtostrf (enkoder, 2, 0, rychlostPCT); 

  lcd.clearDisplay(); 
  lcd.printStr(2, 2, "PWM:      %");      
  lcd.printStr(35,2, rychlostPCT);
  lcd.display();

  if (!digitalRead(zpet2)){
    nastRychlost = false;
    i = 0;
    delay(100);
    nastaveniCerpadel();           
  }
  while (!digitalRead(zpet2));

  if (!digitalRead(vyber)){
     switch (cerpadla){
      case 1:
        rychlost1 = rychlostPWM;
      break;
      case 2:
        rychlost2 = rychlostPWM;
      break;
      case 3:
        rychlost3 = rychlostPWM;    
      break;
      case 4:
        rychlost4  = rychlostPWM;     
      break;
           }
      nastRychlost = false;
      nastCerpadel = 0;
      i = 0;
      nastaveniCerpadel();
      delay(100);
    //rychlostPWM = rychlost1;
  while (!digitalRead(vyber));
  }

}

void prutokomer(){

  if ((millis() - staryCas) > 1000) {

    detachInterrupt(pinPreruseni);
    prutok = ((1000.0 / (millis() - staryCas)) * pulzy) / kalibrace;
    prutokML = (prutok / 60) * 1000;
    soucetML += prutokML;

    dtostrf (prutok, 2, 0, prutokPrint);
    dtostrf (prutokML, 2, 0, prutokMLPrint);
    dtostrf (soucetML, 2, 0, soucetMLPrint);
    
    lcd.clearDisplay(); 
    lcd.printStr(ALIGN_CENTER, 2,"NASTAVENI PRUTOKU");  
    lcd.printStr(2,15,"Prutok: ");
    lcd.printStr(50,15,prutokPrint);
    lcd.printStr(ALIGN_RIGHT,15," l/min");
    lcd.printStr(2,28,"Aktualni: ");
    lcd.printStr(50,28,prutokMLPrint);
    lcd.printStr(ALIGN_RIGHT,28," ml/sek");
    lcd.printStr(2,41,"Soucet: ");
    lcd.printStr(50,41,soucetMLPrint);
    lcd.printStr(ALIGN_RIGHT,41," ml");
    lcd.display();
    pulzy = 0;
    staryCas = millis();
    attachInterrupt(pinPreruseni, prictiPulz, FALLING);
  }
  if (soucetML > 1000){
    digitalWrite(led1,HIGH);
  }


 if (!digitalRead(zpet2)){
    nastPrutoku = false;
    delay(100);
    nastaveniCerpadel();        
  }
  while (!digitalRead(zpet2));
}
void prictiPulz() {
  pulzy++;
}
 
void casovac(){
  lcd.clearDisplay(); 
  lcd.printStr(2, 2,"CASOVAC");  
  lcd.display();
  
 if (!digitalRead(zpet2)){
    nastCasovace = false;
    delay(100);
    nastaveniCerpadel();        
  }
  while (!digitalRead(zpet2));
}
void cykly(){

  lcd.clearDisplay(); 
  lcd.printStr(2, 2,"POCET CYKLU");  
  lcd.display();
  
 if (!digitalRead(zpet2)){
    nastCyklu = false;
    delay(100);
    nastaveniCerpadel();        
  }
  while (!digitalRead(zpet2));
}